# Задание 
Рассмотрим таблицу фиксации прохода через турникет
```sql
create table gate(employee text, check_time timestamp, is_entered int);
```

- employee - имя сотрудника 
- check_time - время фиксации прохода
- is_entered - вход - 1, выход 0

Известно, что за каждым входом следует выход, в начале дня всегда вход, последний всегда выход.

Необходимо вывести сотрудников и дни, когда они находились на рабочем месте менее 8 часов


WITH daily_entries AS ( 
  SELECT
    employee,
    CAST(check_time AS DATE) AS work_date,
    check_time,
    is_entered,
    ROW_NUMBER() OVER (
      PARTITION BY employee, CAST(check_time AS DATE), is_entered
      ORDER BY check_time
    ) AS seq
  FROM gate
),
paired_entries AS (
  SELECT
    e.employee,
    e.work_date,
    e.check_time AS enter_time,
    x.check_time AS exit_time,
    EXTRACT(EPOCH FROM (x.check_time - e.check_time)) / 3600.0 AS hours_spent  -- в часах
  FROM daily_entries e
  JOIN daily_entries x ON
    e.employee = x.employee
    AND e.work_date = x.work_date
    AND e.is_entered = 1
    AND x.is_entered = 0
    AND e.seq = x.seq
)
SELECT
  employee,
  work_date
FROM paired_entries
GROUP BY employee, work_date
HAVING SUM(hours_spent) < 8.0
ORDER BY employee, work_date;
